(function($){
  $(document).on('submit', '#smm-order-form', function(e){
    e.preventDefault();
    const $form = $(this), $out = $('#smm-order-result');
    $out.text('جاري الإرسال...');
    $.post(SMM_API.ajax_url, $form.serialize())
      .done(function(resp){
        if(resp.success){
          const data = resp.data;
          $out.html('✅ تم إنشاء الطلب. رقم الطلب: <b>' + (data.order || '—') + '</b>');
        } else {
          $out.html('❌ ' + (resp.data && resp.data.message ? resp.data.message : 'حدث خطأ'));
        }
      })
      .fail(function(){
        $out.text('❌ فشل الاتصال بالسيرفر.');
      });
  });

  $(document).on('submit', '#smm-status-form', function(e){
    e.preventDefault();
    const $form = $(this), $out = $('#smm-status-result');
    $out.text('جاري الاستعلام...');
    $.post(SMM_API.ajax_url, $form.serialize())
      .done(function(resp){
        if(resp.success){
          const d = resp.data;
          $out.html(
            '<div>الحالة: <b>'+(d.status||'—')+'</b></div>' +
            '<div>الرصيد المستهلك: <b>'+(d.charge||'—')+'</b></div>' +
            '<div>المتبقي: <b>'+(d.remains||'—')+'</b></div>' +
            '<div>البدء: <b>'+(d.start_count||'—')+'</b></div>' +
            '<div>العملة: <b>'+(d.currency||'—')+'</b></div>'
          );
        } else {
          $out.html('❌ ' + (resp.data && resp.data.message ? resp.data.message : 'حدث خطأ'));
        }
      })
      .fail(function(){
        $out.text('❌ فشل الاتصال بالسيرفر.');
      });
  });
})(jQuery);
