jQuery(document).ready(function ($) {
    var loadingSpinner = '<div id="loading-spinner" class="lds-ellipsis" style="display: none;"><div></div><div></div><div></div><div></div></div>';
    $('#ph_custom_field_search').after(loadingSpinner);

    $('#ph_custom_field_search').on('click', function () {
        var username = $('#ph_custom_field').val();
        var nonce = ph_ajax_obj.nonce;
        var product_id = ph_ajax_obj.product_id;
        var ph_min = ph_ajax_obj.ph_min; // Minimum quantity per selected item
        

        $('#ph_custom_field_result').html('');
        $('#loading-spinner').show();

        if (username) {
            $.ajax({
                url: ph_ajax_obj.ajax_url,
                type: 'POST',
                data: {
                    action: 'panelhelper_search',
                    username: username,
                    nonce: nonce,
                    product_id: product_id,
                },
                success: function (response) {
                    $('#loading-spinner').hide();

                    if (response.success) {
                        var response = response.data;

                        if (response.success) {
                            var apiData = response.data;

                            // Determine max selections based on PHP-configured divide_likes
                            var maxSelections = ph_ajax_obj.divide_likes ? 10 : 1;

                            apiData.forEach(function (item) {
                                var thumbnailHtml = '<div class="thumbnail-item" data-link="' + item.link + '">' +
                                    '<img src="' + item.thumbnail + '" alt="Thumbnail" style="max-width: 100px; margin: 5px; cursor: pointer;">' +
                                    '</div>';
                                $('#ph_custom_field_result').append(thumbnailHtml);
                            });

                            var selectedLinks = [];

                            function updateOverlayText() {
                                var selectedQuantity = parseInt($('#quantity').val()) || 0;
                                var overlayText = selectedLinks.length > 0 ? Math.floor(selectedQuantity / selectedLinks.length) : 0;

                                $('.thumbnail-item.selected').each(function () {
                                    $(this).find('.overlay').text("+" + overlayText);
                                });
                            }

                            function showError(message) {
                                $('#error-message').remove();
                                $('<p id="error-message" style="color: red; margin: 10px 0;">' + message + '</p>').insertBefore('#ph_custom_field_result');
                            }

                            function enforceSelectionLimit() {
                                var selectedQuantity = parseInt($('#quantity').val()) || 0;
                                var maxSelectableItems = Math.floor(selectedQuantity / ph_min);

                                if (selectedLinks.length > maxSelectableItems) {
                                    // Reduce selected items to fit within the allowable range
                                    var itemsToDeselect = selectedLinks.length - maxSelectableItems;
                                    for (var i = 0; i < itemsToDeselect; i++) {
                                        var deselectLink = selectedLinks.pop(); // Remove from selectedLinks
                                        $('.thumbnail-item[data-link="' + deselectLink + '"]').removeClass('selected')
                                            .find('.overlay').remove(); // Deselect and remove overlay
                                        $('.thumbnail-item[data-link="' + deselectLink + '"] img').css('filter', 'none'); // Reset brightness
                                    }
                                }

                                $('#ph_selected_link').val(selectedLinks.join(','));
                                updateOverlayText();
                            }

                            $('.thumbnail-item').on('click', function () {
                                var $this = $(this);
                                var link = $this.data('link');

                                if (maxSelections === 1) {
                                    $('.thumbnail-item').removeClass('selected');
                                    $this.addClass('selected');
                                    selectedLinks = [link];
                                } else {
                                    if ($this.hasClass('selected')) {
                                        $this.removeClass('selected');
                                        selectedLinks = selectedLinks.filter(function (item) {
                                            return item !== link;
                                        });
                                    } else if (selectedLinks.length < maxSelections) {
                                        $this.addClass('selected');
                                        selectedLinks.push(link);
                                    }
                                }

                                var selectedQuantity = parseInt($('#quantity').val()) || 0;
                                if (selectedLinks.length > 0 && Math.floor(selectedQuantity / selectedLinks.length) < ph_min) {
                                    showError('Quantity too low. Please select a higher quantity.');
                                    $this.removeClass('selected');
                                    selectedLinks = selectedLinks.filter(function (item) {
                                        return item !== link;
                                    });
                                } else {
                                    $('#error-message').remove();
                                }

                                $('#ph_selected_link').val(selectedLinks.join(','));

                                if ($this.hasClass('selected')) {
                                    var overlay = $('<div class="overlay"></div>');
                                    var img = $this.find('img');
                                    $this.append(overlay);
                                    img.css('filter', 'brightness(70%)');
                                } else {
                                    $this.find('.overlay').remove();
                                    $this.find('img').css('filter', 'none');
                                }

                                updateOverlayText();
                            });

                            $('#quantity').on('change', function () {
                                var selectedQuantity = parseInt($(this).val()) || 0;

                                if (selectedLinks.length > 0 && Math.floor(selectedQuantity / selectedLinks.length) < ph_min) {
                                    showError('Quantity too low. Adjusting selected items.');
                                    enforceSelectionLimit(); // Auto-deselect items if needed
                                } else {
                                    $('#error-message').remove();
                                }

                                updateOverlayText();
                            });
                        } else {
                            $('#ph_custom_field_result').html('<p>Error: Invalid response.</p>');
                        }
                    }
                },
                error: function () {
                    $('#loading-spinner').hide();
                    $('#ph_custom_field_result').html('<p>Something went wrong. Please try again.</p>');
                }
            });
        } else {
            $('#loading-spinner').hide();
            $('#ph_custom_field_result').html('<p>Please enter a username.</p>');
        }
    });
});
